# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sdmodule import *
from .sdgraphdefinition import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDGraphDefinitionMgr(SDAPIObject):
    """
    Keep track of all available graph definitions. There is only one SDGraphDefinitionMgr, that you can retrieve from the SDApplication
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDGraphDefinitionMgr
        """
        super(SDGraphDefinitionMgr, self).__init__(APIContext, handle, *args, **kwargs)

    def getGraphDefinitions(self) -> SDArray[SDModule]:
        """
        Get all available SDGraphDefinition

        """
        outSDModuleArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraphDefinitionMgr_getGraphDefinitions(self.mHandle, ctypes.byref(outSDModuleArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDModuleArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDModuleArray.value, ownHandle=True)

    def addGraphDefinition(self, sdGraphDefinition : SDGraphDefinition) -> None:
        """
        Add a new graph definition. The Id has to be unique in the application

        :param sdGraphDefinition: The SDGraphDefinition to add
        """
        _res = self.mAPIContext.SDGraphDefinitionMgr_addGraphDefinition(self.mHandle, sdGraphDefinition.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getGraphDefinitionFromId(self, id : str) -> Optional[SDGraphDefinition]:
        """
        Get SDGraphDefinition that match the specified Id

        :param id: The id of the SDGraphDefinition to retrieve
        """
        outSDGraphDefinition = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraphDefinitionMgr_getGraphDefinitionFromId(self.mHandle, ctypes.create_string_buffer(id.encode('utf-8')), ctypes.byref(outSDGraphDefinition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDGraphDefinition, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDGraphDefinition.value, ownHandle=True)

